/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.entity.animal;

import java.util.List;
import java.util.UUID;
import lotr.common.LOTRMod;
import lotr.common.entity.LOTREntities;
import lotr.common.entity.LOTRRandomSkinEntity;
import lotr.common.entity.ai.LOTREntityAIAttackOnCollide2;
import lotr.common.entity.ai.LOTREntityAIFlee;
import lotr.common.entity.animal.LOTRAmbientCreature;
import lotr.common.entity.animal.LOTRAmbientSpawnChecks;
import lotr.common.entity.animal.LOTREntityMidges;
import lotr.common.world.biome.LOTRBiomeGenFarHaradJungle;
import lotr.common.world.biome.LOTRBiomeGenFarHaradMangrove;
import lotr.common.world.biome.LOTRBiomeGenFarHaradSwamp;
import lotr.common.world.biome.LOTRBiomeGenForodwaith;
import lotr.common.world.biome.LOTRBiomeGenLastDesert;
import lotr.common.world.biome.LOTRBiomeGenNearHarad;
import lotr.common.world.biome.LOTRBiomeGenRedSemiDesert;
import lotr.common.world.biome.LOTRBiomeGenRhunSemiDesert;
import lotr.common.world.biome.LOTRBiomeGenTaiga;
import lotr.common.world.biome.LOTRBiomeGenTaiga2;
import lotr.common.world.biome.LOTRBiomeGenTaigaRhun;
import lotr.common.world.biome.LOTRBiomeGenTundra;
import lotr.common.world.biome.LOTRBiomeGenTundra2;
import lotr.common.world.biome.LOTRBiomeGenTundra3;
import lotr.common.world.biome.LOTRBiomeGenTundra4;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.command.IEntitySelector;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAILeapAtTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAIPanic;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAITempt;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;

public class LOTREntityFrog
extends EntityAnimal
implements LOTRAmbientCreature,
LOTRRandomSkinEntity,
LOTRBiomeGenNearHarad.ImmuneToFrost,
LOTRBiomeGenNearHarad.ImmuneToHeat {
    public IEntitySelector frogAttackRange = new IEntitySelector(){

        public boolean func_82704_a(Entity entity) {
            return entity instanceof EntityLivingBase && entity.func_70089_S() && LOTREntityFrog.this.func_70068_e(entity) < 16.0;
        }
    };
    public EntityAIBase attackAI = new LOTREntityAIAttackOnCollide2((EntityCreature)this, 1.4, true);
    public EntityAIBase panicAI = new EntityAIPanic((EntityCreature)this, 1.5);

    public LOTREntityFrog(World world) {
        super(world);
        this.func_70105_a(0.5f, 0.5f);
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(0, this.panicAI);
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAIPanic((EntityCreature)this, 2.0));
        this.field_70714_bg.func_75776_a(1, this.attackAI);
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new LOTREntityAIFlee((EntityCreature)this, 2.0));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAILeapAtTarget((EntityLiving)this, 0.4f));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAITempt((EntityCreature)this, 1.4, Items.field_151123_aH, false));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIWander((EntityCreature)this, 1.2));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 15.0f));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, LOTREntityMidges.class, 0, true, false, this.frogAttackRange));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(10.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.15);
        this.func_110140_aT().func_111150_b(SharedMonsterAttributes.field_111264_e).func_111128_a(1.0);
    }

    public boolean func_70652_k(Entity entity) {
        if (!(entity instanceof LOTREntityMidges)) {
            return false;
        }
        float damage = (float)this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e();
        boolean success = entity.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), damage);
        if (success) {
            float knockback = 0.75f;
            entity.func_70024_g((double)(-MathHelper.func_76126_a((float)(this.field_70177_z * (float)Math.PI / 180.0f)) * knockback * 0.5f), 0.0, (double)(MathHelper.func_76134_b((float)(this.field_70177_z * (float)Math.PI / 180.0f)) * knockback * 0.5f));
        }
        return success;
    }

    public boolean func_70097_a(DamageSource damagesource, float f) {
        boolean success = super.func_70097_a(damagesource, f);
        if (success) {
            Entity attacker;
            if (this.func_70631_g_() && (attacker = damagesource.func_76346_g()) instanceof EntityLivingBase) {
                List list = this.field_70170_p.func_72839_b((Entity)this, this.field_70121_D.func_72314_b(12.0, 12.0, 12.0));
                for (Entity entity : list) {
                    LOTREntityFrog frog;
                    if (entity.getClass() != this.getClass() || (frog = (LOTREntityFrog)entity).func_70631_g_()) continue;
                    frog.func_70624_b((EntityLivingBase)attacker);
                }
            }
            if (this.getFrogType() == FrogType.DESERT && damagesource.func_76346_g() instanceof EntityLivingBase) {
                ((EntityLivingBase)damagesource.func_76346_g()).func_70690_d(new PotionEffect(Potion.field_76436_u.field_76415_H, 100, 1));
            }
        }
        return success;
    }

    public EntityAgeable func_90011_a(EntityAgeable entity) {
        LOTREntityFrog mate = (LOTREntityFrog)entity;
        LOTREntityFrog child = new LOTREntityFrog(this.field_70170_p);
        if (this.field_70146_Z.nextBoolean()) {
            child.setFrogType(this.getFrogType());
        } else {
            child.setFrogType(mate.getFrogType());
        }
        return child;
    }

    protected void func_70628_a(boolean flag, int i) {
        if (flag && this.field_70146_Z.nextInt(3) == 0) {
            this.func_145779_a(Items.field_151123_aH, 1);
        }
    }

    public boolean func_70877_b(ItemStack itemstack) {
        return itemstack.func_77973_b() == Items.field_151076_bf;
    }

    public boolean func_70692_ba() {
        return true;
    }

    public float func_70783_a(int i, int j, int k) {
        Block block = this.field_70170_p.func_147439_a(i, j - 1, k);
        if (block == Blocks.field_150349_c) {
            return 10.0f;
        }
        return this.field_70170_p.func_72801_o(i, j, k) - 0.5f;
    }

    public boolean func_70601_bi() {
        if (super.func_70601_bi()) {
            return LOTRAmbientSpawnChecks.canSpawn((EntityLiving)this, 8, 4, 32, 4, Material.field_151585_k, Material.field_151582_l);
        }
        return false;
    }

    protected String func_70673_aS() {
        return "lotr:frog.death";
    }

    protected String func_70621_aR() {
        return "lotr:frog.hurt";
    }

    protected String func_70639_aQ() {
        return "lotr:frog.say";
    }

    protected void func_145780_a(int i, int j, int k, Block block) {
        this.func_85030_a("lotr:frog.step", 0.75f, this.func_70647_i());
    }

    public ItemStack getPickedResult(MovingObjectPosition target) {
        return new ItemStack(LOTRMod.spawnEgg, 1, LOTREntities.getEntityID((Entity)this));
    }

    public float func_70647_i() {
        return super.func_70647_i() * 1.3f;
    }

    public boolean func_70650_aV() {
        return true;
    }

    @Override
    public void setUniqueID(UUID uuid) {
        this.field_96093_i = uuid;
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_75682_a(16, (Object)0);
        this.field_70180_af.func_75682_a(17, (Object)1);
    }

    public String getFrogTextureDir() {
        return this.getFrogType().textureDir;
    }

    public FrogType getFrogType() {
        byte i = this.field_70180_af.func_75683_a(16);
        if (i < 0 || i >= FrogType.values().length) {
            i = 0;
        }
        return FrogType.values()[i];
    }

    public void setFrogType(FrogType type) {
        this.setFrogType(type.ordinal());
    }

    public IEntityLivingData func_110161_a(IEntityLivingData data) {
        int k;
        data = super.func_110161_a(data);
        int i = MathHelper.func_76128_c((double)this.field_70165_t);
        BiomeGenBase biome = this.field_70170_p.func_72807_a(i, k = MathHelper.func_76128_c((double)this.field_70161_v));
        if (biome instanceof LOTRBiomeGenTundra || biome instanceof LOTRBiomeGenTaiga || biome instanceof LOTRBiomeGenTaiga2 || biome instanceof LOTRBiomeGenTaigaRhun || biome instanceof LOTRBiomeGenTundra2 || biome instanceof LOTRBiomeGenTundra3 || biome instanceof LOTRBiomeGenTundra4 || biome instanceof LOTRBiomeGenForodwaith) {
            this.setFrogType(FrogType.SNOW);
        } else if (biome instanceof LOTRBiomeGenLastDesert || biome instanceof LOTRBiomeGenRhunSemiDesert || biome instanceof LOTRBiomeGenRedSemiDesert || biome instanceof LOTRBiomeGenNearHarad || biome instanceof LOTRBiomeGenFarHaradJungle || biome instanceof LOTRBiomeGenFarHaradMangrove || biome instanceof LOTRBiomeGenFarHaradSwamp) {
            this.setFrogType(FrogType.DESERT);
        } else {
            this.setFrogType(FrogType.COMMON);
        }
        return data;
    }

    public void setFrogType(int i) {
        this.field_70180_af.func_75692_b(16, (Object)((byte)i));
    }

    public boolean isFrogStill() {
        return this.field_70180_af.func_75683_a(17) == 1;
    }

    public void setFrogStill(boolean flag) {
        this.field_70180_af.func_75692_b(17, (Object)((byte)(flag ? 1 : 0)));
    }

    public void func_70037_a(NBTTagCompound nbt) {
        super.func_70037_a(nbt);
        this.setFrogType(nbt.func_74762_e("FrogType"));
        this.setFrogStill(nbt.func_74767_n("FrogStill"));
    }

    public void func_70014_b(NBTTagCompound nbt) {
        super.func_70014_b(nbt);
        nbt.func_74768_a("FrogType", this.getFrogType().ordinal());
        nbt.func_74757_a("FrogStill", this.isFrogStill());
    }

    public static enum FrogType {
        COMMON("common", true),
        DESERT("desert", true),
        SNOW("snow", true);

        public boolean canSteal;
        public String textureDir;

        private FrogType(String s, boolean flag) {
            this.textureDir = s;
            this.canSteal = flag;
        }
    }
}

